package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsAnalyticsPrevailingSentimentType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Positive")
    POSITIVE("Positive", "1"),

    @JsonProperty("Negative")
    NEGATIVE("Negative", "2"),

    @JsonProperty("Neutral")
    NEUTRAL("Neutral", "3");

    private final String name;
    private final String value;

    private NewsAnalyticsPrevailingSentimentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
