package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsAnalyticsSourceType implements Enum {

    @JsonProperty("Articles")
    ARTICLES("Articles", "0"),

    @JsonProperty("Alerts")
    ALERTS("Alerts", "1"),

    @JsonProperty("ArticlesAndAlerts")
    ARTICLES_AND_ALERTS("ArticlesAndAlerts", "2");

    private final String name;
    private final String value;

    private NewsAnalyticsSourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
