package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsFilterOperatorType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("GreaterThan")
    GREATER_THAN("GreaterThan", "1"),

    @JsonProperty("GreaterThanOrEqualTo")
    GREATER_THAN_OR_EQUAL_TO("GreaterThanOrEqualTo", "2"),

    @JsonProperty("LessThan")
    LESS_THAN("LessThan", "3"),

    @JsonProperty("LessThanOrEqualTo")
    LESS_THAN_OR_EQUAL_TO("LessThanOrEqualTo", "4"),

    @JsonProperty("EqualTo")
    EQUAL_TO("EqualTo", "5");

    private final String name;
    private final String value;

    private NewsFilterOperatorType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
