package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsItemsLanguageType implements Enum {

    @JsonProperty("English")
    ENGLISH("English", "0"),

    @JsonProperty("AllLanguages")
    ALL_LANGUAGES("AllLanguages", "1"),

    @JsonProperty("Selected")
    SELECTED("Selected", "2");

    private final String name;
    private final String value;

    private NewsItemsLanguageType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
