package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum NewsItemsSourceType implements Enum {

    @JsonProperty("AllNews")
    ALL_NEWS("AllNews", "0"),

    @JsonProperty("ReutersNews")
    REUTERS_NEWS("ReutersNews", "1"),

    @JsonProperty("Selected")
    SELECTED("Selected", "2");

    private final String name;
    private final String value;

    private NewsItemsSourceType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
