package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PremiumPricingRegionCycle implements Enum {

    @JsonProperty("PremiumPricingAsia3PM")
    PREMIUM_PRICING_ASIA3PM("PremiumPricingAsia3PM", "0"),

    @JsonProperty("PremiumPricingAsia4PM")
    PREMIUM_PRICING_ASIA4PM("PremiumPricingAsia4PM", "1"),

    @JsonProperty("PremiumPricingAsia6PM")
    PREMIUM_PRICING_ASIA6PM("PremiumPricingAsia6PM", "2"),

    @JsonProperty("PremiumPricingAsia10PM")
    PREMIUM_PRICING_ASIA10PM("PremiumPricingAsia10PM", "3"),

    @JsonProperty("PremiumPricingEmea12PM")
    PREMIUM_PRICING_EMEA12PM("PremiumPricingEmea12PM", "4"),

    @JsonProperty("PremiumPricingEmea2PM")
    PREMIUM_PRICING_EMEA2PM("PremiumPricingEmea2PM", "5"),

    @JsonProperty("PremiumPricingEmea4PM")
    PREMIUM_PRICING_EMEA4PM("PremiumPricingEmea4PM", "6"),

    @JsonProperty("PremiumPricingEmea6PM")
    PREMIUM_PRICING_EMEA6PM("PremiumPricingEmea6PM", "7"),

    @JsonProperty("PremiumPricingUS3PM")
    PREMIUM_PRICING_US3PM("PremiumPricingUS3PM", "8"),

    @JsonProperty("PremiumPricingUS4PM")
    PREMIUM_PRICING_US4PM("PremiumPricingUS4PM", "9");

    private final String name;
    private final String value;

    private PremiumPricingRegionCycle(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
