package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum PreviewMode implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Content")
    CONTENT("Content", "1"),

    @JsonProperty("Instrument")
    INSTRUMENT("Instrument", "2");

    private final String name;
    private final String value;

    private PreviewMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
