package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RelativeFiscalYearType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("FY1")
    FY1("FY1", "1"),

    @JsonProperty("FY2")
    FY2("FY2", "2"),

    @JsonProperty("FY3")
    FY3("FY3", "3"),

    @JsonProperty("FY4")
    FY4("FY4", "4"),

    @JsonProperty("FY5")
    FY5("FY5", "5");

    private final String name;
    private final String value;

    private RelativeFiscalYearType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
