package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RelativeQuarterType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Q1")
    Q1("Q1", "1"),

    @JsonProperty("Q2")
    Q2("Q2", "2"),

    @JsonProperty("Q3")
    Q3("Q3", "3"),

    @JsonProperty("Q4")
    Q4("Q4", "4"),

    @JsonProperty("Q5")
    Q5("Q5", "5"),

    @JsonProperty("Q6")
    Q6("Q6", "6"),

    @JsonProperty("Q7")
    Q7("Q7", "7"),

    @JsonProperty("Q8")
    Q8("Q8", "8");

    private final String name;
    private final String value;

    private RelativeQuarterType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
