package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum RelativeSemiAnnualType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("S1")
    S1("S1", "1"),

    @JsonProperty("S2")
    S2("S2", "2"),

    @JsonProperty("S3")
    S3("S3", "3"),

    @JsonProperty("S4")
    S4("S4", "4");

    private final String name;
    private final String value;

    private RelativeSemiAnnualType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
