package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportCompanyType implements Enum {

    @JsonProperty("Consolidated")
    CONSOLIDATED("Consolidated", "0"),

    @JsonProperty("Parent")
    PARENT("Parent", "1"),

    @JsonProperty("ParentAndConsolidated")
    PARENT_AND_CONSOLIDATED("ParentAndConsolidated", "2");

    private final String name;
    private final String value;

    private ReportCompanyType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
