package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportCompressionType implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Zip")
    ZIP("Zip", "1"),

    @JsonProperty("GZip")
    GZIP("GZip", "2");

    private final String name;
    private final String value;

    private ReportCompressionType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
