package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportDateRangeType implements Enum {

    @JsonProperty("NoRange")
    NO_RANGE("NoRange", "0"),

    @JsonProperty("Init")
    INIT("Init", "1"),

    @JsonProperty("Range")
    RANGE("Range", "2"),

    @JsonProperty("Delta")
    DELTA("Delta", "3"),

    @JsonProperty("Last")
    LAST("Last", "4"),

    @JsonProperty("Relative")
    RELATIVE("Relative", "5"),

    @JsonProperty("PerIdentifier")
    PER_IDENTIFIER("PerIdentifier", "6");

    private final String name;
    private final String value;

    private ReportDateRangeType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
