package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportDelimiter implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Pipe")
    PIPE("Pipe", "1"),

    @JsonProperty("Semicolon")
    SEMICOLON("Semicolon", "2"),

    @JsonProperty("Space")
    SPACE("Space", "3"),

    @JsonProperty("Tab")
    TAB("Tab", "4");

    private final String name;
    private final String value;

    private ReportDelimiter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
