package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportHeaderFieldType implements Enum {

    @JsonProperty("EndTime")
    END_TIME("EndTime", "0"),

    @JsonProperty("RowCount")
    ROW_COUNT("RowCount", "1"),

    @JsonProperty("StartTime")
    START_TIME("StartTime", "2"),

    @JsonProperty("User")
    USER("User", "3"),

    @JsonProperty("Timezone")
    TIMEZONE("Timezone", "4");

    private final String name;
    private final String value;

    private ReportHeaderFieldType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
