package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportIsoEventType implements Enum {

    @JsonProperty("ACTV")
    ACTV("ACTV", "0"),

    @JsonProperty("BIDS")
    BIDS("BIDS", "1"),

    @JsonProperty("BONU")
    BONU("BONU", "2"),

    @JsonProperty("BPUT")
    BPUT("BPUT", "3"),

    @JsonProperty("BRUP")
    BRUP("BRUP", "4"),

    @JsonProperty("CAPD")
    CAPD("CAPD", "5"),

    @JsonProperty("CAPG")
    CAPG("CAPG", "6"),

    @JsonProperty("CAPI")
    CAPI("CAPI", "7"),

    @JsonProperty("CHAN")
    CHAN("CHAN", "8"),

    @JsonProperty("CMET")
    CMET("CMET", "9"),

    @JsonProperty("CONV")
    CONV("CONV", "10"),

    @JsonProperty("DECR")
    DECR("DECR", "11"),

    @JsonProperty("DFLT")
    DFLT("DFLT", "12"),

    @JsonProperty("DLST")
    DLST("DLST", "13"),

    @JsonProperty("DRCA")
    DRCA("DRCA", "14"),

    @JsonProperty("DRIP")
    DRIP("DRIP", "15"),

    @JsonProperty("DVCA")
    DVCA("DVCA", "16"),

    @JsonProperty("DVOP")
    DVOP("DVOP", "17"),

    @JsonProperty("DVSE")
    DVSE("DVSE", "18"),

    @JsonProperty("EXOF")
    EXOF("EXOF", "19"),

    @JsonProperty("EXRI")
    EXRI("EXRI", "20"),

    @JsonProperty("EXTM")
    EXTM("EXTM", "21"),

    @JsonProperty("EXWA")
    EXWA("EXWA", "22"),

    @JsonProperty("INCR")
    INCR("INCR", "23"),

    @JsonProperty("INTR")
    INTR("INTR", "24"),

    @JsonProperty("LIQU")
    LIQU("LIQU", "25"),

    @JsonProperty("MCAL")
    MCAL("MCAL", "26"),

    @JsonProperty("MEET")
    MEET("MEET", "27"),

    @JsonProperty("MRGR")
    MRGR("MRGR", "28"),

    @JsonProperty("ODLT")
    ODLT("ODLT", "29"),

    @JsonProperty("OMET")
    OMET("OMET", "30"),

    @JsonProperty("OTHR")
    OTHR("OTHR", "31"),

    @JsonProperty("PARI")
    PARI("PARI", "32"),

    @JsonProperty("PCAL")
    PCAL("PCAL", "33"),

    @JsonProperty("PPMT")
    PPMT("PPMT", "34"),

    @JsonProperty("PRIO")
    PRIO("PRIO", "35"),

    @JsonProperty("REDM")
    REDM("REDM", "36"),

    @JsonProperty("REDO")
    REDO("REDO", "37"),

    @JsonProperty("RHDI")
    RHDI("RHDI", "38"),

    @JsonProperty("RHTS")
    RHTS("RHTS", "39"),

    @JsonProperty("SHPR")
    SHPR("SHPR", "40"),

    @JsonProperty("SOFF")
    SOFF("SOFF", "41"),

    @JsonProperty("SPLF")
    SPLF("SPLF", "42"),

    @JsonProperty("SPLR")
    SPLR("SPLR", "43"),

    @JsonProperty("SUSP")
    SUSP("SUSP", "44"),

    @JsonProperty("TEND")
    TEND("TEND", "45"),

    @JsonProperty("XMET")
    XMET("XMET", "46");

    private final String name;
    private final String value;

    private ReportIsoEventType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
