package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportOutputFormat implements Enum {

    @JsonProperty("CommaSeparatedValues")
    COMMA_SEPARATED_VALUES("CommaSeparatedValues", "0"),

    @JsonProperty("DelimitedValues")
    DELIMITED_VALUES("DelimitedValues", "1"),

    @JsonProperty("IsoFormat")
    ISO_FORMAT("IsoFormat", "2"),

    @JsonProperty("Xml")
    XML("Xml", "3");

    private final String name;
    private final String value;

    private ReportOutputFormat(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
