package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ReportTemplateTypes implements Enum {

    @JsonProperty("CommoditiesCorrectionsHistory")
    COMMODITIES_CORRECTIONS_HISTORY("CommoditiesCorrectionsHistory", "0"),

    @JsonProperty("FixedIncomeAnalytics")
    FIXED_INCOME_ANALYTICS("FixedIncomeAnalytics", "1"),

    @JsonProperty("Composite")
    COMPOSITE("Composite", "2"),

    @JsonProperty("CorporateActions")
    CORPORATE_ACTIONS("CorporateActions", "3"),

    @JsonProperty("EndOfDayPricing")
    END_OF_DAY_PRICING("EndOfDayPricing", "4"),

    @JsonProperty("EstimatesActual")
    ESTIMATES_ACTUAL("EstimatesActual", "5"),

    @JsonProperty("DetailEstimateFootnotes")
    DETAIL_ESTIMATE_FOOTNOTES("DetailEstimateFootnotes", "6"),

    @JsonProperty("EstimatesCompanyFootnotes")
    ESTIMATES_COMPANY_FOOTNOTES("EstimatesCompanyFootnotes", "7"),

    @JsonProperty("EstimatesDetail")
    ESTIMATES_DETAIL("EstimatesDetail", "8"),

    @JsonProperty("FundAllocation")
    FUND_ALLOCATION("FundAllocation", "9"),

    @JsonProperty("EstimatesSummary")
    ESTIMATES_SUMMARY("EstimatesSummary", "10"),

    @JsonProperty("LegalEntityAudit")
    LEGAL_ENTITY_AUDIT("LegalEntityAudit", "11"),

    @JsonProperty("LegalEntityDetail")
    LEGAL_ENTITY_DETAIL("LegalEntityDetail", "12"),

    @JsonProperty("LegalEntityHierarchy")
    LEGAL_ENTITY_HIERARCHY("LegalEntityHierarchy", "13"),

    @JsonProperty("Owners")
    OWNERS("Owners", "14"),

    @JsonProperty("NewsAnalyticsCommoditiesAndEnergy")
    NEWS_ANALYTICS_COMMODITIES_AND_ENERGY("NewsAnalyticsCommoditiesAndEnergy", "15"),

    @JsonProperty("NewsAnalytics")
    NEWS_ANALYTICS("NewsAnalytics", "16"),

    @JsonProperty("NewsItems")
    NEWS_ITEMS("NewsItems", "17"),

    @JsonProperty("IntradayPricing")
    INTRADAY_PRICING("IntradayPricing", "18"),

    @JsonProperty("PremiumEndOfDayPricing")
    PREMIUM_END_OF_DAY_PRICING("PremiumEndOfDayPricing", "19"),

    @JsonProperty("BondRatings")
    BOND_RATINGS("BondRatings", "20"),

    @JsonProperty("BondSchedules")
    BOND_SCHEDULES("BondSchedules", "21"),

    @JsonProperty("TermsAndConditions")
    TERMS_AND_CONDITIONS("TermsAndConditions", "22"),

    @JsonProperty("TimeseriesPricing")
    TIMESERIES_PRICING("TimeseriesPricing", "23"),

    @JsonProperty("SymbolCrossReference")
    SYMBOL_CROSS_REFERENCE("SymbolCrossReference", "24"),

    @JsonProperty("PremiumPricing")
    PREMIUM_PRICING("PremiumPricing", "25"),

    @JsonProperty("TechnicalIndicators")
    TECHNICAL_INDICATORS("TechnicalIndicators", "26"),

    @JsonProperty("MBSFactorHistory")
    MBSFACTOR_HISTORY("MBSFactorHistory", "27"),

    @JsonProperty("TrancheFactorHistory")
    TRANCHE_FACTOR_HISTORY("TrancheFactorHistory", "28"),

    @JsonProperty("EstimatesADC")
    ESTIMATES_ADC("EstimatesADC", "29"),

    @JsonProperty("Starmine")
    STARMINE("Starmine", "30"),

    @JsonProperty("TickHistoryMarketDepth")
    TICK_HISTORY_MARKET_DEPTH("TickHistoryMarketDepth", "31"),

    @JsonProperty("TickHistoryIntradaySummaries")
    TICK_HISTORY_INTRADAY_SUMMARIES("TickHistoryIntradaySummaries", "32"),

    @JsonProperty("TickHistoryTimeAndSales")
    TICK_HISTORY_TIME_AND_SALES("TickHistoryTimeAndSales", "33"),

    @JsonProperty("TickHistoryRaw")
    TICK_HISTORY_RAW("TickHistoryRaw", "34"),

    @JsonProperty("ElektronTimeseries")
    ELEKTRON_TIMESERIES("ElektronTimeseries", "35"),

    @JsonProperty("HistoricalReference")
    HISTORICAL_REFERENCE("HistoricalReference", "36"),

    @JsonProperty("PriceHistory")
    PRICE_HISTORY("PriceHistory", "37");

    private final String name;
    private final String value;

    private ReportTemplateTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
