package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ShareAmountChoice implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("All")
    ALL("All", "1"),

    @JsonProperty("Default")
    DEFAULT("Default", "2"),

    @JsonProperty("Subset")
    SUBSET("Subset", "3");

    private final String name;
    private final String value;

    private ShareAmountChoice(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
