package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum ShareAmountType implements Enum {

    @JsonProperty("Authorised")
    AUTHORISED("Authorised", "0"),

    @JsonProperty("CloselyHeld")
    CLOSELY_HELD("CloselyHeld", "1"),

    @JsonProperty("FreeFloat")
    FREE_FLOAT("FreeFloat", "2"),

    @JsonProperty("Issued")
    ISSUED("Issued", "3"),

    @JsonProperty("Listed")
    LISTED("Listed", "4"),

    @JsonProperty("Outstanding")
    OUTSTANDING("Outstanding", "5"),

    @JsonProperty("Treasure")
    TREASURE("Treasure", "6"),

    @JsonProperty("Unclassified")
    UNCLASSIFIED("Unclassified", "7");

    private final String name;
    private final String value;

    private ShareAmountType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
