package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistoryExtractByMode implements Enum {

    @JsonProperty("Ric")
    RIC("Ric", "0"),

    @JsonProperty("Entity")
    ENTITY("Entity", "1");

    private final String name;
    private final String value;

    private TickHistoryExtractByMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
