package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistoryMarketDepthViewOptions implements Enum {

    @JsonProperty("RawMarketByPrice")
    RAW_MARKET_BY_PRICE("RawMarketByPrice", "0"),

    @JsonProperty("RawMarketByOrder")
    RAW_MARKET_BY_ORDER("RawMarketByOrder", "1"),

    @JsonProperty("RawMarketMaker")
    RAW_MARKET_MAKER("RawMarketMaker", "2"),

    @JsonProperty("LegacyLevel2")
    LEGACY_LEVEL2("LegacyLevel2", "3"),

    @JsonProperty("NormalizedLL2")
    NORMALIZED_LL2("NormalizedLL2", "4");

    private final String name;
    private final String value;

    private TickHistoryMarketDepthViewOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
