package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistoryRawDomain implements Enum {

    @JsonProperty("MarketPrice")
    MARKET_PRICE("MarketPrice", "0"),

    @JsonProperty("MarketByOrder")
    MARKET_BY_ORDER("MarketByOrder", "1"),

    @JsonProperty("MarketByPrice")
    MARKET_BY_PRICE("MarketByPrice", "2"),

    @JsonProperty("MarketMaker")
    MARKET_MAKER("MarketMaker", "3");

    private final String name;
    private final String value;

    private TickHistoryRawDomain(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
