package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistorySort implements Enum {

    @JsonProperty("SingleByRic")
    SINGLE_BY_RIC("SingleByRic", "0"),

    @JsonProperty("SingleByTimestamp")
    SINGLE_BY_TIMESTAMP("SingleByTimestamp", "1");

    private final String name;
    private final String value;

    private TickHistorySort(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
