package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistorySummaryInterval implements Enum {

    @JsonProperty("OneSecond")
    ONE_SECOND("OneSecond", "0"),

    @JsonProperty("FiveSeconds")
    FIVE_SECONDS("FiveSeconds", "1"),

    @JsonProperty("OneMinute")
    ONE_MINUTE("OneMinute", "2"),

    @JsonProperty("FiveMinutes")
    FIVE_MINUTES("FiveMinutes", "3"),

    @JsonProperty("TenMinutes")
    TEN_MINUTES("TenMinutes", "4"),

    @JsonProperty("FifteenMinutes")
    FIFTEEN_MINUTES("FifteenMinutes", "5"),

    @JsonProperty("OneHour")
    ONE_HOUR("OneHour", "6");

    private final String name;
    private final String value;

    private TickHistorySummaryInterval(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
