package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistoryTimeOptions implements Enum {

    @JsonProperty("LocalExchangeTime")
    LOCAL_EXCHANGE_TIME("LocalExchangeTime", "0"),

    @JsonProperty("GmtUtc")
    GMT_UTC("GmtUtc", "1");

    private final String name;
    private final String value;

    private TickHistoryTimeOptions(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
