package thomsonreuters.dss.api.extractions.reporttemplates.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum TickHistoryTimeRangeMode implements Enum {

    @JsonProperty("Inclusive")
    INCLUSIVE("Inclusive", "0"),

    @JsonProperty("Window")
    WINDOW("Window", "1");

    private final String name;
    private final String value;

    private TickHistoryTimeRangeMode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
