package thomsonreuters.dss.api.extractions.schedules.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ReportExtractionCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.schedules.entity.Schedule;
import thomsonreuters.dss.api.extractions.schedules.entity.request.ScheduleEntityRequest;
import thomsonreuters.dss.api.extractions.schedules.schema.SchemaInfo;

public class ScheduleCollectionRequest extends CollectionPageEntityRequest<Schedule, ScheduleEntityRequest>{

    protected ContextPath contextPath;

    public ScheduleCollectionRequest(ContextPath contextPath) {
        super(contextPath, Schedule.class, cp -> new ScheduleEntityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public ReportExtractionCollectionRequest pendingExtractions() {
        return new ReportExtractionCollectionRequest(contextPath.addSegment("PendingExtractions"));
    }

    public ReportExtractionEntityRequest pendingExtractions(String reportExtractionId) {
        return new ReportExtractionEntityRequest(contextPath.addSegment("PendingExtractions").addKeys(new NameValue(reportExtractionId.toString())));
    }

    public ReportExtractionCollectionRequest completedExtractions() {
        return new ReportExtractionCollectionRequest(contextPath.addSegment("CompletedExtractions"));
    }

    public ReportExtractionEntityRequest completedExtractions(String reportExtractionId) {
        return new ReportExtractionEntityRequest(contextPath.addSegment("CompletedExtractions").addKeys(new NameValue(reportExtractionId.toString())));
    }



}
