package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import thomsonreuters.dss.api.extractions.schedules.complex.EndOfDayExtendedTriggerInformation;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type"})
public class CompositeExtendedTriggerInformation extends EndOfDayExtendedTriggerInformation implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    protected CompositeExtendedTriggerInformation() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.CompositeExtendedTriggerInformation";
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCompositeExtendedTriggerInformation() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isErrorCorrected;
        private Boolean isDelta;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isErrorCorrected(Boolean isErrorCorrected) {
            this.isErrorCorrected = isErrorCorrected;
            this.changedFields = changedFields.add("IsErrorCorrected");
            return this;
        }

        public Builder isDelta(Boolean isDelta) {
            this.isDelta = isDelta;
            this.changedFields = changedFields.add("IsDelta");
            return this;
        }

        public CompositeExtendedTriggerInformation build() {
            CompositeExtendedTriggerInformation _x = new CompositeExtendedTriggerInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.CompositeExtendedTriggerInformation";
            _x.isErrorCorrected = isErrorCorrected;
            _x.isDelta = isDelta;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CompositeExtendedTriggerInformation[");
        b.append("IsErrorCorrected=");
        b.append(this.isErrorCorrected);
        b.append(", ");
        b.append("IsDelta=");
        b.append(this.isDelta);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
