package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.schedules.complex.DataAvailabilityTriggerTimeout;
import thomsonreuters.dss.api.extractions.schedules.complex.ExtendedTriggerInformation;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleTrigger;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ExtendedInformation", 
    "TimeOut"})
public class DataAvailabilityTrigger extends ScheduleTrigger implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ExtendedInformation")
    protected ExtendedTriggerInformation extendedInformation;

    @JsonProperty("TimeOut")
    protected DataAvailabilityTriggerTimeout timeOut;

    protected DataAvailabilityTrigger() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTrigger";
    }

    @Property(name="ExtendedInformation")
    @JsonIgnore
    public Optional<ExtendedTriggerInformation> getExtendedInformation() {
        return Optional.ofNullable(extendedInformation);
    }

    public DataAvailabilityTrigger withExtendedInformation(ExtendedTriggerInformation extendedInformation) {
        DataAvailabilityTrigger _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTrigger");
        _x.extendedInformation = extendedInformation;
        return _x;
    }

    @Property(name="TimeOut")
    @JsonIgnore
    public Optional<DataAvailabilityTriggerTimeout> getTimeOut() {
        return Optional.ofNullable(timeOut);
    }

    public DataAvailabilityTrigger withTimeOut(DataAvailabilityTriggerTimeout timeOut) {
        DataAvailabilityTrigger _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTrigger");
        _x.timeOut = timeOut;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataAvailabilityTrigger() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean limitReportToTodaysData;
        private ExtendedTriggerInformation extendedInformation;
        private DataAvailabilityTriggerTimeout timeOut;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder limitReportToTodaysData(Boolean limitReportToTodaysData) {
            this.limitReportToTodaysData = limitReportToTodaysData;
            this.changedFields = changedFields.add("LimitReportToTodaysData");
            return this;
        }

        public Builder extendedInformation(ExtendedTriggerInformation extendedInformation) {
            this.extendedInformation = extendedInformation;
            this.changedFields = changedFields.add("ExtendedInformation");
            return this;
        }

        public Builder timeOut(DataAvailabilityTriggerTimeout timeOut) {
            this.timeOut = timeOut;
            this.changedFields = changedFields.add("TimeOut");
            return this;
        }

        public DataAvailabilityTrigger build() {
            DataAvailabilityTrigger _x = new DataAvailabilityTrigger();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTrigger";
            _x.limitReportToTodaysData = limitReportToTodaysData;
            _x.extendedInformation = extendedInformation;
            _x.timeOut = timeOut;
            return _x;
        }
    }

    private DataAvailabilityTrigger _copy() {
        DataAvailabilityTrigger _x = new DataAvailabilityTrigger();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.limitReportToTodaysData = limitReportToTodaysData;
        _x.extendedInformation = extendedInformation;
        _x.timeOut = timeOut;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataAvailabilityTrigger[");
        b.append("LimitReportToTodaysData=");
        b.append(this.limitReportToTodaysData);
        b.append(", ");
        b.append("ExtendedInformation=");
        b.append(this.extendedInformation);
        b.append(", ");
        b.append("TimeOut=");
        b.append(this.timeOut);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
