package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.complex.HourMinute;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "TriggerTimeoutUserTime", 
    "TriggerTimeoutDayOffset"})
public class DataAvailabilityTriggerTimeout implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TriggerTimeoutUserTime")
    protected HourMinute triggerTimeoutUserTime;

    @JsonProperty("TriggerTimeoutDayOffset")
    protected Integer triggerTimeoutDayOffset;

    protected DataAvailabilityTriggerTimeout() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTriggerTimeout";
    }

    @Property(name="TriggerTimeoutUserTime")
    @JsonIgnore
    public Optional<HourMinute> getTriggerTimeoutUserTime() {
        return Optional.ofNullable(triggerTimeoutUserTime);
    }

    public DataAvailabilityTriggerTimeout withTriggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
        DataAvailabilityTriggerTimeout _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTriggerTimeout");
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        return _x;
    }

    @Property(name="TriggerTimeoutDayOffset")
    @JsonIgnore
    public Optional<Integer> getTriggerTimeoutDayOffset() {
        return Optional.ofNullable(triggerTimeoutDayOffset);
    }

    public DataAvailabilityTriggerTimeout withTriggerTimeoutDayOffset(Integer triggerTimeoutDayOffset) {
        DataAvailabilityTriggerTimeout _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTriggerTimeout");
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HourMinute triggerTimeoutUserTime;
        private Integer triggerTimeoutDayOffset;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder triggerTimeoutUserTime(HourMinute triggerTimeoutUserTime) {
            this.triggerTimeoutUserTime = triggerTimeoutUserTime;
            this.changedFields = changedFields.add("TriggerTimeoutUserTime");
            return this;
        }

        public Builder triggerTimeoutDayOffset(Integer triggerTimeoutDayOffset) {
            this.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            this.changedFields = changedFields.add("TriggerTimeoutDayOffset");
            return this;
        }

        public DataAvailabilityTriggerTimeout build() {
            DataAvailabilityTriggerTimeout _x = new DataAvailabilityTriggerTimeout();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.DataAvailabilityTriggerTimeout";
            _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
            _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
            return _x;
        }
    }

    private DataAvailabilityTriggerTimeout _copy() {
        DataAvailabilityTriggerTimeout _x = new DataAvailabilityTriggerTimeout();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.triggerTimeoutUserTime = triggerTimeoutUserTime;
        _x.triggerTimeoutDayOffset = triggerTimeoutDayOffset;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataAvailabilityTriggerTimeout[");
        b.append("TriggerTimeoutUserTime=");
        b.append(this.triggerTimeoutUserTime);
        b.append(", ");
        b.append("TriggerTimeoutDayOffset=");
        b.append(this.triggerTimeoutDayOffset);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
