package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.schedules.complex.ExtendedTriggerInformation;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "IsErrorCorrected", 
    "IsDelta"})
public class EndOfDayExtendedTriggerInformation extends ExtendedTriggerInformation implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("IsErrorCorrected")
    protected Boolean isErrorCorrected;

    @JsonProperty("IsDelta")
    protected Boolean isDelta;

    protected EndOfDayExtendedTriggerInformation() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.EndOfDayExtendedTriggerInformation";
    }

    @Property(name="IsErrorCorrected")
    @JsonIgnore
    public Optional<Boolean> getIsErrorCorrected() {
        return Optional.ofNullable(isErrorCorrected);
    }

    public EndOfDayExtendedTriggerInformation withIsErrorCorrected(Boolean isErrorCorrected) {
        EndOfDayExtendedTriggerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.EndOfDayExtendedTriggerInformation");
        _x.isErrorCorrected = isErrorCorrected;
        return _x;
    }

    @Property(name="IsDelta")
    @JsonIgnore
    public Optional<Boolean> getIsDelta() {
        return Optional.ofNullable(isDelta);
    }

    public EndOfDayExtendedTriggerInformation withIsDelta(Boolean isDelta) {
        EndOfDayExtendedTriggerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.EndOfDayExtendedTriggerInformation");
        _x.isDelta = isDelta;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEndOfDayExtendedTriggerInformation() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isErrorCorrected;
        private Boolean isDelta;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isErrorCorrected(Boolean isErrorCorrected) {
            this.isErrorCorrected = isErrorCorrected;
            this.changedFields = changedFields.add("IsErrorCorrected");
            return this;
        }

        public Builder isDelta(Boolean isDelta) {
            this.isDelta = isDelta;
            this.changedFields = changedFields.add("IsDelta");
            return this;
        }

        public EndOfDayExtendedTriggerInformation build() {
            EndOfDayExtendedTriggerInformation _x = new EndOfDayExtendedTriggerInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.EndOfDayExtendedTriggerInformation";
            _x.isErrorCorrected = isErrorCorrected;
            _x.isDelta = isDelta;
            return _x;
        }
    }

    private EndOfDayExtendedTriggerInformation _copy() {
        EndOfDayExtendedTriggerInformation _x = new EndOfDayExtendedTriggerInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isErrorCorrected = isErrorCorrected;
        _x.isDelta = isDelta;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EndOfDayExtendedTriggerInformation[");
        b.append("IsErrorCorrected=");
        b.append(this.isErrorCorrected);
        b.append(", ");
        b.append("IsDelta=");
        b.append(this.isDelta);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
