package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Id", 
    "InstrumentId", 
    "Source", 
    "Description", 
    "Trigger", 
    "Status", 
    "DataDateUtc", 
    "LastArrivalUtc", 
    "AverageArrivalUtc"})
public class InstrumentTriggerDetail implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Id")
    protected String id;

    @JsonProperty("InstrumentId")
    protected String instrumentId;

    @JsonProperty("Source")
    protected String source;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("Trigger")
    protected String trigger;

    @JsonProperty("Status")
    protected String status;

    @JsonProperty("DataDateUtc")
    protected OffsetDateTime dataDateUtc;

    @JsonProperty("LastArrivalUtc")
    protected OffsetDateTime lastArrivalUtc;

    @JsonProperty("AverageArrivalUtc")
    protected OffsetDateTime averageArrivalUtc;

    protected InstrumentTriggerDetail() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail";
    }

    @Property(name="Id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public InstrumentTriggerDetail withId(String id) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.id = id;
        return _x;
    }

    @Property(name="InstrumentId")
    @JsonIgnore
    public Optional<String> getInstrumentId() {
        return Optional.ofNullable(instrumentId);
    }

    public InstrumentTriggerDetail withInstrumentId(String instrumentId) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.instrumentId = instrumentId;
        return _x;
    }

    @Property(name="Source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public InstrumentTriggerDetail withSource(String source) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.source = source;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public InstrumentTriggerDetail withDescription(String description) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.description = description;
        return _x;
    }

    @Property(name="Trigger")
    @JsonIgnore
    public Optional<String> getTrigger() {
        return Optional.ofNullable(trigger);
    }

    public InstrumentTriggerDetail withTrigger(String trigger) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.trigger = trigger;
        return _x;
    }

    @Property(name="Status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public InstrumentTriggerDetail withStatus(String status) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.status = status;
        return _x;
    }

    @Property(name="DataDateUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getDataDateUtc() {
        return Optional.ofNullable(dataDateUtc);
    }

    public InstrumentTriggerDetail withDataDateUtc(OffsetDateTime dataDateUtc) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.dataDateUtc = dataDateUtc;
        return _x;
    }

    @Property(name="LastArrivalUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastArrivalUtc() {
        return Optional.ofNullable(lastArrivalUtc);
    }

    public InstrumentTriggerDetail withLastArrivalUtc(OffsetDateTime lastArrivalUtc) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.lastArrivalUtc = lastArrivalUtc;
        return _x;
    }

    @Property(name="AverageArrivalUtc")
    @JsonIgnore
    public Optional<OffsetDateTime> getAverageArrivalUtc() {
        return Optional.ofNullable(averageArrivalUtc);
    }

    public InstrumentTriggerDetail withAverageArrivalUtc(OffsetDateTime averageArrivalUtc) {
        InstrumentTriggerDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail");
        _x.averageArrivalUtc = averageArrivalUtc;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String instrumentId;
        private String source;
        private String description;
        private String trigger;
        private String status;
        private OffsetDateTime dataDateUtc;
        private OffsetDateTime lastArrivalUtc;
        private OffsetDateTime averageArrivalUtc;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("Id");
            return this;
        }

        public Builder instrumentId(String instrumentId) {
            this.instrumentId = instrumentId;
            this.changedFields = changedFields.add("InstrumentId");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder trigger(String trigger) {
            this.trigger = trigger;
            this.changedFields = changedFields.add("Trigger");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("Status");
            return this;
        }

        public Builder dataDateUtc(OffsetDateTime dataDateUtc) {
            this.dataDateUtc = dataDateUtc;
            this.changedFields = changedFields.add("DataDateUtc");
            return this;
        }

        public Builder lastArrivalUtc(OffsetDateTime lastArrivalUtc) {
            this.lastArrivalUtc = lastArrivalUtc;
            this.changedFields = changedFields.add("LastArrivalUtc");
            return this;
        }

        public Builder averageArrivalUtc(OffsetDateTime averageArrivalUtc) {
            this.averageArrivalUtc = averageArrivalUtc;
            this.changedFields = changedFields.add("AverageArrivalUtc");
            return this;
        }

        public InstrumentTriggerDetail build() {
            InstrumentTriggerDetail _x = new InstrumentTriggerDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.InstrumentTriggerDetail";
            _x.id = id;
            _x.instrumentId = instrumentId;
            _x.source = source;
            _x.description = description;
            _x.trigger = trigger;
            _x.status = status;
            _x.dataDateUtc = dataDateUtc;
            _x.lastArrivalUtc = lastArrivalUtc;
            _x.averageArrivalUtc = averageArrivalUtc;
            return _x;
        }
    }

    private InstrumentTriggerDetail _copy() {
        InstrumentTriggerDetail _x = new InstrumentTriggerDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.instrumentId = instrumentId;
        _x.source = source;
        _x.description = description;
        _x.trigger = trigger;
        _x.status = status;
        _x.dataDateUtc = dataDateUtc;
        _x.lastArrivalUtc = lastArrivalUtc;
        _x.averageArrivalUtc = averageArrivalUtc;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstrumentTriggerDetail[");
        b.append("Id=");
        b.append(this.id);
        b.append(", ");
        b.append("InstrumentId=");
        b.append(this.instrumentId);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Trigger=");
        b.append(this.trigger);
        b.append(", ");
        b.append("Status=");
        b.append(this.status);
        b.append(", ");
        b.append("DataDateUtc=");
        b.append(this.dataDateUtc);
        b.append(", ");
        b.append("LastArrivalUtc=");
        b.append(this.lastArrivalUtc);
        b.append(", ");
        b.append("AverageArrivalUtc=");
        b.append(this.averageArrivalUtc);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
