package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.schedules.complex.ExtendedTriggerInformation;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "WaitForToleranceData"})
public class PremiumPricingExtendedTriggerInformation extends ExtendedTriggerInformation implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("WaitForToleranceData")
    protected Boolean waitForToleranceData;

    protected PremiumPricingExtendedTriggerInformation() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.PremiumPricingExtendedTriggerInformation";
    }

    @Property(name="WaitForToleranceData")
    @JsonIgnore
    public Optional<Boolean> getWaitForToleranceData() {
        return Optional.ofNullable(waitForToleranceData);
    }

    public PremiumPricingExtendedTriggerInformation withWaitForToleranceData(Boolean waitForToleranceData) {
        PremiumPricingExtendedTriggerInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.PremiumPricingExtendedTriggerInformation");
        _x.waitForToleranceData = waitForToleranceData;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPremiumPricingExtendedTriggerInformation() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean waitForToleranceData;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder waitForToleranceData(Boolean waitForToleranceData) {
            this.waitForToleranceData = waitForToleranceData;
            this.changedFields = changedFields.add("WaitForToleranceData");
            return this;
        }

        public PremiumPricingExtendedTriggerInformation build() {
            PremiumPricingExtendedTriggerInformation _x = new PremiumPricingExtendedTriggerInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.PremiumPricingExtendedTriggerInformation";
            _x.waitForToleranceData = waitForToleranceData;
            return _x;
        }
    }

    private PremiumPricingExtendedTriggerInformation _copy() {
        PremiumPricingExtendedTriggerInformation _x = new PremiumPricingExtendedTriggerInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.waitForToleranceData = waitForToleranceData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PremiumPricingExtendedTriggerInformation[");
        b.append("WaitForToleranceData=");
        b.append(this.waitForToleranceData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
