package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "LimitReportToTodaysData"})
public class ScheduleTrigger implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("LimitReportToTodaysData")
    protected Boolean limitReportToTodaysData;

    protected ScheduleTrigger() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleTrigger";
    }

    @Property(name="LimitReportToTodaysData")
    @JsonIgnore
    public Optional<Boolean> getLimitReportToTodaysData() {
        return Optional.ofNullable(limitReportToTodaysData);
    }

    public ScheduleTrigger withLimitReportToTodaysData(Boolean limitReportToTodaysData) {
        ScheduleTrigger _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleTrigger");
        _x.limitReportToTodaysData = limitReportToTodaysData;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean limitReportToTodaysData;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder limitReportToTodaysData(Boolean limitReportToTodaysData) {
            this.limitReportToTodaysData = limitReportToTodaysData;
            this.changedFields = changedFields.add("LimitReportToTodaysData");
            return this;
        }

        public ScheduleTrigger build() {
            ScheduleTrigger _x = new ScheduleTrigger();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.ScheduleTrigger";
            _x.limitReportToTodaysData = limitReportToTodaysData;
            return _x;
        }
    }

    private ScheduleTrigger _copy() {
        ScheduleTrigger _x = new ScheduleTrigger();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.limitReportToTodaysData = limitReportToTodaysData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduleTrigger[");
        b.append("LimitReportToTodaysData=");
        b.append(this.limitReportToTodaysData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
