package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleRecurrence;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ExtractionDateTime", 
    "IsImmediate"})
public class SingleRecurrence extends ScheduleRecurrence implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("ExtractionDateTime")
    protected OffsetDateTime extractionDateTime;

    @JsonProperty("IsImmediate")
    protected Boolean isImmediate;

    protected SingleRecurrence() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.SingleRecurrence";
    }

    @Property(name="ExtractionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExtractionDateTime() {
        return Optional.ofNullable(extractionDateTime);
    }

    public SingleRecurrence withExtractionDateTime(OffsetDateTime extractionDateTime) {
        SingleRecurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.SingleRecurrence");
        _x.extractionDateTime = extractionDateTime;
        return _x;
    }

    @Property(name="IsImmediate")
    @JsonIgnore
    public Optional<Boolean> getIsImmediate() {
        return Optional.ofNullable(isImmediate);
    }

    public SingleRecurrence withIsImmediate(Boolean isImmediate) {
        SingleRecurrence _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.SingleRecurrence");
        _x.isImmediate = isImmediate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSingleRecurrence() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime extractionDateTime;
        private Boolean isImmediate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder extractionDateTime(OffsetDateTime extractionDateTime) {
            this.extractionDateTime = extractionDateTime;
            this.changedFields = changedFields.add("ExtractionDateTime");
            return this;
        }

        public Builder isImmediate(Boolean isImmediate) {
            this.isImmediate = isImmediate;
            this.changedFields = changedFields.add("IsImmediate");
            return this;
        }

        public SingleRecurrence build() {
            SingleRecurrence _x = new SingleRecurrence();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.SingleRecurrence";
            _x.extractionDateTime = extractionDateTime;
            _x.isImmediate = isImmediate;
            return _x;
        }
    }

    private SingleRecurrence _copy() {
        SingleRecurrence _x = new SingleRecurrence();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.extractionDateTime = extractionDateTime;
        _x.isImmediate = isImmediate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SingleRecurrence[");
        b.append("ExtractionDateTime=");
        b.append(this.extractionDateTime);
        b.append(", ");
        b.append("IsImmediate=");
        b.append(this.isImmediate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
