package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.complex.HourMinute;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleTrigger;
import thomsonreuters.dss.api.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "At"})
public class TimeTrigger extends ScheduleTrigger implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("At")
    protected List<HourMinute> at;

    @JsonProperty("At@nextLink")
    protected String atNextLink;

    protected TimeTrigger() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.TimeTrigger";
    }

    @Property(name="At")
    @JsonIgnore
    public CollectionPage<HourMinute> getAt() {
        return new CollectionPage<HourMinute>(contextPath, HourMinute.class, at, Optional.ofNullable(atNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTimeTrigger() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean limitReportToTodaysData;
        private List<HourMinute> at;
        private String atNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder limitReportToTodaysData(Boolean limitReportToTodaysData) {
            this.limitReportToTodaysData = limitReportToTodaysData;
            this.changedFields = changedFields.add("LimitReportToTodaysData");
            return this;
        }

        public Builder at(List<HourMinute> at) {
            this.at = at;
            this.changedFields = changedFields.add("At");
            return this;
        }

        public Builder atNextLink(String atNextLink) {
            this.atNextLink = atNextLink;
            this.changedFields = changedFields.add("At");
            return this;
        }

        public TimeTrigger build() {
            TimeTrigger _x = new TimeTrigger();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.TimeTrigger";
            _x.limitReportToTodaysData = limitReportToTodaysData;
            _x.at = at;
            _x.atNextLink = atNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeTrigger[");
        b.append("LimitReportToTodaysData=");
        b.append(this.limitReportToTodaysData);
        b.append(", ");
        b.append("At=");
        b.append(this.at);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
