package thomsonreuters.dss.api.extractions.schedules.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import system.enums.DayOfWeek;
import system.schema.SchemaInfo;

import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleRecurrence;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Days"})
public class WeeklyRecurrence extends ScheduleRecurrence implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Days")
    protected List<DayOfWeek> days;

    @JsonProperty("Days@nextLink")
    protected String daysNextLink;

    protected WeeklyRecurrence() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.WeeklyRecurrence";
    }

    @Property(name="Days")
    @JsonIgnore
    public CollectionPage<DayOfWeek> getDays() {
        return new CollectionPage<DayOfWeek>(contextPath, DayOfWeek.class, days, Optional.ofNullable(daysNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderWeeklyRecurrence() {
        return new Builder();
    }

    public static final class Builder {
        private List<DayOfWeek> days;
        private String daysNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder days(List<DayOfWeek> days) {
            this.days = days;
            this.changedFields = changedFields.add("Days");
            return this;
        }

        public Builder daysNextLink(String daysNextLink) {
            this.daysNextLink = daysNextLink;
            this.changedFields = changedFields.add("Days");
            return this;
        }

        public WeeklyRecurrence build() {
            WeeklyRecurrence _x = new WeeklyRecurrence();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.WeeklyRecurrence";
            _x.days = days;
            _x.daysNextLink = daysNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WeeklyRecurrence[");
        b.append("Days=");
        b.append(this.days);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
