package thomsonreuters.dss.api.extractions.schedules.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ReportExtractionCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleRecurrence;
import thomsonreuters.dss.api.extractions.schedules.complex.ScheduleTrigger;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.SubjectListEntityRequest;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ScheduleId", 
    "Name", 
    "OutputFileName", 
    "TimeZone", 
    "Recurrence", 
    "Trigger", 
    "UserId", 
    "CreateDate", 
    "LastChangeDate", 
    "ListId", 
    "ReportTemplateId"})
public class Schedule implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ScheduleId")
    protected String scheduleId;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("OutputFileName")
    protected String outputFileName;

    @JsonProperty("TimeZone")
    protected String timeZone;

    @JsonProperty("Recurrence")
    protected ScheduleRecurrence recurrence;

    @JsonProperty("Trigger")
    protected ScheduleTrigger trigger;

    @JsonProperty("UserId")
    protected Integer userId;

    @JsonProperty("CreateDate")
    protected OffsetDateTime createDate;

    @JsonProperty("LastChangeDate")
    protected OffsetDateTime lastChangeDate;

    @JsonProperty("ListId")
    protected String listId;

    @JsonProperty("ReportTemplateId")
    protected String reportTemplateId;

    protected Schedule() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String scheduleId;
        private String name;
        private String outputFileName;
        private String timeZone;
        private ScheduleRecurrence recurrence;
        private ScheduleTrigger trigger;
        private Integer userId;
        private OffsetDateTime createDate;
        private OffsetDateTime lastChangeDate;
        private String listId;
        private String reportTemplateId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            this.changedFields = changedFields.add("ScheduleId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            this.changedFields = changedFields.add("OutputFileName");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("TimeZone");
            return this;
        }

        public Builder recurrence(ScheduleRecurrence recurrence) {
            this.recurrence = recurrence;
            this.changedFields = changedFields.add("Recurrence");
            return this;
        }

        public Builder trigger(ScheduleTrigger trigger) {
            this.trigger = trigger;
            this.changedFields = changedFields.add("Trigger");
            return this;
        }

        public Builder userId(Integer userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("UserId");
            return this;
        }

        public Builder createDate(OffsetDateTime createDate) {
            this.createDate = createDate;
            this.changedFields = changedFields.add("CreateDate");
            return this;
        }

        public Builder lastChangeDate(OffsetDateTime lastChangeDate) {
            this.lastChangeDate = lastChangeDate;
            this.changedFields = changedFields.add("LastChangeDate");
            return this;
        }

        public Builder listId(String listId) {
            this.listId = listId;
            this.changedFields = changedFields.add("ListId");
            return this;
        }

        public Builder reportTemplateId(String reportTemplateId) {
            this.reportTemplateId = reportTemplateId;
            this.changedFields = changedFields.add("ReportTemplateId");
            return this;
        }

        public Schedule build() {
            Schedule _x = new Schedule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule";
            _x.scheduleId = scheduleId;
            _x.name = name;
            _x.outputFileName = outputFileName;
            _x.timeZone = timeZone;
            _x.recurrence = recurrence;
            _x.trigger = trigger;
            _x.userId = userId;
            _x.createDate = createDate;
            _x.lastChangeDate = lastChangeDate;
            _x.listId = listId;
            _x.reportTemplateId = reportTemplateId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && scheduleId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(scheduleId.toString()));
        }
    }

    @Property(name="ScheduleId")
    @JsonIgnore
    public Optional<String> getScheduleId() {
        return Optional.ofNullable(scheduleId);
    }

    public Schedule withScheduleId(String scheduleId) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("ScheduleId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.scheduleId = scheduleId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Schedule withName(String name) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("Name");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.name = name;
        return _x;
    }

    @Property(name="OutputFileName")
    @JsonIgnore
    public Optional<String> getOutputFileName() {
        return Optional.ofNullable(outputFileName);
    }

    public Schedule withOutputFileName(String outputFileName) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("OutputFileName");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.outputFileName = outputFileName;
        return _x;
    }

    @Property(name="TimeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public Schedule withTimeZone(String timeZone) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("TimeZone");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.timeZone = timeZone;
        return _x;
    }

    @Property(name="Recurrence")
    @JsonIgnore
    public Optional<ScheduleRecurrence> getRecurrence() {
        return Optional.ofNullable(recurrence);
    }

    public Schedule withRecurrence(ScheduleRecurrence recurrence) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("Recurrence");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.recurrence = recurrence;
        return _x;
    }

    @Property(name="Trigger")
    @JsonIgnore
    public Optional<ScheduleTrigger> getTrigger() {
        return Optional.ofNullable(trigger);
    }

    public Schedule withTrigger(ScheduleTrigger trigger) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("Trigger");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.trigger = trigger;
        return _x;
    }

    @Property(name="UserId")
    @JsonIgnore
    public Optional<Integer> getUserId() {
        return Optional.ofNullable(userId);
    }

    public Schedule withUserId(Integer userId) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("UserId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.userId = userId;
        return _x;
    }

    @Property(name="CreateDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreateDate() {
        return Optional.ofNullable(createDate);
    }

    public Schedule withCreateDate(OffsetDateTime createDate) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("CreateDate");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.createDate = createDate;
        return _x;
    }

    @Property(name="LastChangeDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastChangeDate() {
        return Optional.ofNullable(lastChangeDate);
    }

    public Schedule withLastChangeDate(OffsetDateTime lastChangeDate) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("LastChangeDate");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.lastChangeDate = lastChangeDate;
        return _x;
    }

    @Property(name="ListId")
    @JsonIgnore
    public Optional<String> getListId() {
        return Optional.ofNullable(listId);
    }

    public Schedule withListId(String listId) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("ListId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.listId = listId;
        return _x;
    }

    @Property(name="ReportTemplateId")
    @JsonIgnore
    public Optional<String> getReportTemplateId() {
        return Optional.ofNullable(reportTemplateId);
    }

    public Schedule withReportTemplateId(String reportTemplateId) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("ReportTemplateId");
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.Schedules.Schedule");
        _x.reportTemplateId = reportTemplateId;
        return _x;
    }

    @NavigationProperty(name="SubjectList")
    @JsonIgnore
    public SubjectListEntityRequest getSubjectList() {
        return new SubjectListEntityRequest(contextPath.addSegment("SubjectList"));
    }

    @NavigationProperty(name="ReportTemplate")
    @JsonIgnore
    public ReportTemplateEntityRequest getReportTemplate() {
        return new ReportTemplateEntityRequest(contextPath.addSegment("ReportTemplate"));
    }

    @NavigationProperty(name="PendingExtractions")
    @JsonIgnore
    public ReportExtractionCollectionRequest getPendingExtractions() {
        return new ReportExtractionCollectionRequest(
                        contextPath.addSegment("PendingExtractions"));
    }

    @NavigationProperty(name="CompletedExtractions")
    @JsonIgnore
    public ReportExtractionCollectionRequest getCompletedExtractions() {
        return new ReportExtractionCollectionRequest(
                        contextPath.addSegment("CompletedExtractions"));
    }

    @NavigationProperty(name="LastExtraction")
    @JsonIgnore
    public ReportExtractionEntityRequest getLastExtraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("LastExtraction"));
    }

    @NavigationProperty(name="NextExtraction")
    @JsonIgnore
    public ReportExtractionEntityRequest getNextExtraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("NextExtraction"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schedule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Schedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schedule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Schedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Schedule _copy() {
        Schedule _x = new Schedule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.scheduleId = scheduleId;
        _x.name = name;
        _x.outputFileName = outputFileName;
        _x.timeZone = timeZone;
        _x.recurrence = recurrence;
        _x.trigger = trigger;
        _x.userId = userId;
        _x.createDate = createDate;
        _x.lastChangeDate = lastChangeDate;
        _x.listId = listId;
        _x.reportTemplateId = reportTemplateId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Schedule[");
        b.append("ScheduleId=");
        b.append(this.scheduleId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("OutputFileName=");
        b.append(this.outputFileName);
        b.append(", ");
        b.append("TimeZone=");
        b.append(this.timeZone);
        b.append(", ");
        b.append("Recurrence=");
        b.append(this.recurrence);
        b.append(", ");
        b.append("Trigger=");
        b.append(this.trigger);
        b.append(", ");
        b.append("UserId=");
        b.append(this.userId);
        b.append(", ");
        b.append("CreateDate=");
        b.append(this.createDate);
        b.append(", ");
        b.append("LastChangeDate=");
        b.append(this.lastChangeDate);
        b.append(", ");
        b.append("ListId=");
        b.append(this.listId);
        b.append(", ");
        b.append("ReportTemplateId=");
        b.append(this.reportTemplateId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
