package thomsonreuters.dss.api.extractions.schedules.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.reportextractions.collection.request.ReportExtractionCollectionRequest;
import thomsonreuters.dss.api.extractions.reportextractions.entity.request.ReportExtractionEntityRequest;
import thomsonreuters.dss.api.extractions.reporttemplates.entity.request.ReportTemplateEntityRequest;
import thomsonreuters.dss.api.extractions.schedules.entity.Schedule;
import thomsonreuters.dss.api.extractions.schedules.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.SubjectListEntityRequest;

@JsonIgnoreType
public class ScheduleEntityRequest extends EntityRequest<Schedule> {

    public ScheduleEntityRequest(ContextPath contextPath) {
        super(Schedule.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SubjectListEntityRequest subjectList() {
        return new SubjectListEntityRequest(contextPath.addSegment("SubjectList"));
    }

    public ReportTemplateEntityRequest reportTemplate() {
        return new ReportTemplateEntityRequest(contextPath.addSegment("ReportTemplate"));
    }

    public ReportExtractionCollectionRequest pendingExtractions() {
        return new ReportExtractionCollectionRequest(
                        contextPath.addSegment("PendingExtractions"));
    }

    public ReportExtractionEntityRequest pendingExtractions(String reportExtractionId) {
        return new ReportExtractionEntityRequest(contextPath.addSegment("PendingExtractions").addKeys(new NameValue(reportExtractionId.toString())));
    }

    public ReportExtractionCollectionRequest completedExtractions() {
        return new ReportExtractionCollectionRequest(
                        contextPath.addSegment("CompletedExtractions"));
    }

    public ReportExtractionEntityRequest completedExtractions(String reportExtractionId) {
        return new ReportExtractionEntityRequest(contextPath.addSegment("CompletedExtractions").addKeys(new NameValue(reportExtractionId.toString())));
    }

    public ReportExtractionEntityRequest lastExtraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("LastExtraction"));
    }

    public ReportExtractionEntityRequest nextExtraction() {
        return new ReportExtractionEntityRequest(contextPath.addSegment("NextExtraction"));
    }

}
