package thomsonreuters.dss.api.extractions.subjectlists.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.subjectlists.collection.request.EntityListItemCollectionRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.EntityList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.EntityListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

public class EntityListCollectionRequest extends CollectionPageEntityRequest<EntityList, EntityListEntityRequest>{

    protected ContextPath contextPath;

    public EntityListCollectionRequest(ContextPath contextPath) {
        super(contextPath, EntityList.class, cp -> new EntityListEntityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public EntityListItemCollectionRequest items() {
        return new EntityListItemCollectionRequest(contextPath.addSegment("Items"));
    }

    public EntityListItemEntityRequest items(String entityListItemKey) {
        return new EntityListItemEntityRequest(contextPath.addSegment("Items").addKeys(new NameValue(entityListItemKey.toString())));
    }

}
