package thomsonreuters.dss.api.extractions.subjectlists.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import thomsonreuters.dss.api.extractions.subjectlists.collection.request.InstrumentListItemCollectionRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.InstrumentList;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.entity.request.InstrumentListItemEntityRequest;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;

public class InstrumentListCollectionRequest extends CollectionPageEntityRequest<InstrumentList, InstrumentListEntityRequest>{

    protected ContextPath contextPath;

    public InstrumentListCollectionRequest(ContextPath contextPath) {
        super(contextPath, InstrumentList.class, cp -> new InstrumentListEntityRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public InstrumentListItemCollectionRequest items() {
        return new InstrumentListItemCollectionRequest(contextPath.addSegment("Items"));
    }

    public InstrumentListItemEntityRequest items(String instrumentListItemKey) {
        return new InstrumentListItemEntityRequest(contextPath.addSegment("Items").addKeys(new NameValue(instrumentListItemKey.toString())));
    }

}
