package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.CriteriaListFilter;
import thomsonreuters.dss.api.extractions.subjectlists.enums.RangeOperator;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Op", 
    "Max", 
    "Min", 
    "Value"})
public class DateRangeFilter extends CriteriaListFilter implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("Op")
    protected RangeOperator op;

    @JsonProperty("Max")
    protected OffsetDateTime max;

    @JsonProperty("Min")
    protected OffsetDateTime min;

    @JsonProperty("Value")
    protected OffsetDateTime value;

    protected DateRangeFilter() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter";
    }

    @Property(name="Op")
    @JsonIgnore
    public Optional<RangeOperator> getOp() {
        return Optional.ofNullable(op);
    }

    public DateRangeFilter withOp(RangeOperator op) {
        DateRangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter");
        _x.op = op;
        return _x;
    }

    @Property(name="Max")
    @JsonIgnore
    public Optional<OffsetDateTime> getMax() {
        return Optional.ofNullable(max);
    }

    public DateRangeFilter withMax(OffsetDateTime max) {
        DateRangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter");
        _x.max = max;
        return _x;
    }

    @Property(name="Min")
    @JsonIgnore
    public Optional<OffsetDateTime> getMin() {
        return Optional.ofNullable(min);
    }

    public DateRangeFilter withMin(OffsetDateTime min) {
        DateRangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter");
        _x.min = min;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<OffsetDateTime> getValue() {
        return Optional.ofNullable(value);
    }

    public DateRangeFilter withValue(OffsetDateTime value) {
        DateRangeFilter _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDateRangeFilter() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private RangeOperator op;
        private OffsetDateTime max;
        private OffsetDateTime min;
        private OffsetDateTime value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder op(RangeOperator op) {
            this.op = op;
            this.changedFields = changedFields.add("Op");
            return this;
        }

        public Builder max(OffsetDateTime max) {
            this.max = max;
            this.changedFields = changedFields.add("Max");
            return this;
        }

        public Builder min(OffsetDateTime min) {
            this.min = min;
            this.changedFields = changedFields.add("Min");
            return this;
        }

        public Builder value(OffsetDateTime value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public DateRangeFilter build() {
            DateRangeFilter _x = new DateRangeFilter();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.DateRangeFilter";
            _x.name = name;
            _x.op = op;
            _x.max = max;
            _x.min = min;
            _x.value = value;
            return _x;
        }
    }

    private DateRangeFilter _copy() {
        DateRangeFilter _x = new DateRangeFilter();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.op = op;
        _x.max = max;
        _x.min = min;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DateRangeFilter[");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Op=");
        b.append(this.op);
        b.append(", ");
        b.append("Max=");
        b.append(this.max);
        b.append(", ");
        b.append("Min=");
        b.append(this.min);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
