package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesAppendResult;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesValidationResult;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ValidationResult", 
    "AppendResult"})
public class EntitiesAppendIdentifiersResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidationResult")
    protected EntitiesValidationResult validationResult;

    @JsonProperty("AppendResult")
    protected EntitiesAppendResult appendResult;

    protected EntitiesAppendIdentifiersResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendIdentifiersResult";
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<EntitiesValidationResult> getValidationResult() {
        return Optional.ofNullable(validationResult);
    }

    public EntitiesAppendIdentifiersResult withValidationResult(EntitiesValidationResult validationResult) {
        EntitiesAppendIdentifiersResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendIdentifiersResult");
        _x.validationResult = validationResult;
        return _x;
    }

    @Property(name="AppendResult")
    @JsonIgnore
    public Optional<EntitiesAppendResult> getAppendResult() {
        return Optional.ofNullable(appendResult);
    }

    public EntitiesAppendIdentifiersResult withAppendResult(EntitiesAppendResult appendResult) {
        EntitiesAppendIdentifiersResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendIdentifiersResult");
        _x.appendResult = appendResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EntitiesValidationResult validationResult;
        private EntitiesAppendResult appendResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validationResult(EntitiesValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = changedFields.add("ValidationResult");
            return this;
        }

        public Builder appendResult(EntitiesAppendResult appendResult) {
            this.appendResult = appendResult;
            this.changedFields = changedFields.add("AppendResult");
            return this;
        }

        public EntitiesAppendIdentifiersResult build() {
            EntitiesAppendIdentifiersResult _x = new EntitiesAppendIdentifiersResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendIdentifiersResult";
            _x.validationResult = validationResult;
            _x.appendResult = appendResult;
            return _x;
        }
    }

    private EntitiesAppendIdentifiersResult _copy() {
        EntitiesAppendIdentifiersResult _x = new EntitiesAppendIdentifiersResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validationResult = validationResult;
        _x.appendResult = appendResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitiesAppendIdentifiersResult[");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append(", ");
        b.append("AppendResult=");
        b.append(this.appendResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
