package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityAppendDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "AppendedEntityCount", 
    "AppendDuplicates"})
public class EntitiesAppendResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AppendedEntityCount")
    protected Integer appendedEntityCount;

    @JsonProperty("AppendDuplicates")
    protected List<EntityAppendDuplicate> appendDuplicates;

    @JsonProperty("AppendDuplicates@nextLink")
    protected String appendDuplicatesNextLink;

    protected EntitiesAppendResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendResult";
    }

    @Property(name="AppendedEntityCount")
    @JsonIgnore
    public Optional<Integer> getAppendedEntityCount() {
        return Optional.ofNullable(appendedEntityCount);
    }

    public EntitiesAppendResult withAppendedEntityCount(Integer appendedEntityCount) {
        EntitiesAppendResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendResult");
        _x.appendedEntityCount = appendedEntityCount;
        return _x;
    }

    @Property(name="AppendDuplicates")
    @JsonIgnore
    public CollectionPage<EntityAppendDuplicate> getAppendDuplicates() {
        return new CollectionPage<EntityAppendDuplicate>(contextPath, EntityAppendDuplicate.class, appendDuplicates, Optional.ofNullable(appendDuplicatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer appendedEntityCount;
        private List<EntityAppendDuplicate> appendDuplicates;
        private String appendDuplicatesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appendedEntityCount(Integer appendedEntityCount) {
            this.appendedEntityCount = appendedEntityCount;
            this.changedFields = changedFields.add("AppendedEntityCount");
            return this;
        }

        public Builder appendDuplicates(List<EntityAppendDuplicate> appendDuplicates) {
            this.appendDuplicates = appendDuplicates;
            this.changedFields = changedFields.add("AppendDuplicates");
            return this;
        }

        public Builder appendDuplicatesNextLink(String appendDuplicatesNextLink) {
            this.appendDuplicatesNextLink = appendDuplicatesNextLink;
            this.changedFields = changedFields.add("AppendDuplicates");
            return this;
        }

        public EntitiesAppendResult build() {
            EntitiesAppendResult _x = new EntitiesAppendResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesAppendResult";
            _x.appendedEntityCount = appendedEntityCount;
            _x.appendDuplicates = appendDuplicates;
            _x.appendDuplicatesNextLink = appendDuplicatesNextLink;
            return _x;
        }
    }

    private EntitiesAppendResult _copy() {
        EntitiesAppendResult _x = new EntitiesAppendResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appendedEntityCount = appendedEntityCount;
        _x.appendDuplicates = appendDuplicates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitiesAppendResult[");
        b.append("AppendedEntityCount=");
        b.append(this.appendedEntityCount);
        b.append(", ");
        b.append("AppendDuplicates=");
        b.append(this.appendDuplicates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
