package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedEntity;
import thomsonreuters.dss.api.content.schema.SchemaInfo;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesValidationResult;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ValidatedEntities", 
    "ValidationResult"})
public class EntitiesValidateIdentifiersResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidatedEntities")
    protected List<ValidatedEntity> validatedEntities;

    @JsonProperty("ValidatedEntities@nextLink")
    protected String validatedEntitiesNextLink;

    @JsonProperty("ValidationResult")
    protected EntitiesValidationResult validationResult;

    protected EntitiesValidateIdentifiersResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidateIdentifiersResult";
    }

    @Property(name="ValidatedEntities")
    @JsonIgnore
    public CollectionPage<ValidatedEntity> getValidatedEntities() {
        return new CollectionPage<ValidatedEntity>(contextPath, ValidatedEntity.class, validatedEntities, Optional.ofNullable(validatedEntitiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<EntitiesValidationResult> getValidationResult() {
        return Optional.ofNullable(validationResult);
    }

    public EntitiesValidateIdentifiersResult withValidationResult(EntitiesValidationResult validationResult) {
        EntitiesValidateIdentifiersResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidateIdentifiersResult");
        _x.validationResult = validationResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ValidatedEntity> validatedEntities;
        private String validatedEntitiesNextLink;
        private EntitiesValidationResult validationResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validatedEntities(List<ValidatedEntity> validatedEntities) {
            this.validatedEntities = validatedEntities;
            this.changedFields = changedFields.add("ValidatedEntities");
            return this;
        }

        public Builder validatedEntitiesNextLink(String validatedEntitiesNextLink) {
            this.validatedEntitiesNextLink = validatedEntitiesNextLink;
            this.changedFields = changedFields.add("ValidatedEntities");
            return this;
        }

        public Builder validationResult(EntitiesValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = changedFields.add("ValidationResult");
            return this;
        }

        public EntitiesValidateIdentifiersResult build() {
            EntitiesValidateIdentifiersResult _x = new EntitiesValidateIdentifiersResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidateIdentifiersResult";
            _x.validatedEntities = validatedEntities;
            _x.validatedEntitiesNextLink = validatedEntitiesNextLink;
            _x.validationResult = validationResult;
            return _x;
        }
    }

    private EntitiesValidateIdentifiersResult _copy() {
        EntitiesValidateIdentifiersResult _x = new EntitiesValidateIdentifiersResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validatedEntities = validatedEntities;
        _x.validationResult = validationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitiesValidateIdentifiersResult[");
        b.append("ValidatedEntities=");
        b.append(this.validatedEntities);
        b.append(", ");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
