package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityValidationDuplicate;
import thomsonreuters.dss.api.extractions.subjectlists.complex.EntityValidationMessage;
import thomsonreuters.dss.api.extractions.subjectlists.schema.SchemaInfo;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ValidEntityCount", 
    "ValidationDuplicates", 
    "Messages"})
public class EntitiesValidationResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ValidEntityCount")
    protected Integer validEntityCount;

    @JsonProperty("ValidationDuplicates")
    protected List<EntityValidationDuplicate> validationDuplicates;

    @JsonProperty("ValidationDuplicates@nextLink")
    protected String validationDuplicatesNextLink;

    @JsonProperty("Messages")
    protected List<EntityValidationMessage> messages;

    @JsonProperty("Messages@nextLink")
    protected String messagesNextLink;

    protected EntitiesValidationResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidationResult";
    }

    @Property(name="ValidEntityCount")
    @JsonIgnore
    public Optional<Integer> getValidEntityCount() {
        return Optional.ofNullable(validEntityCount);
    }

    public EntitiesValidationResult withValidEntityCount(Integer validEntityCount) {
        EntitiesValidationResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidationResult");
        _x.validEntityCount = validEntityCount;
        return _x;
    }

    @Property(name="ValidationDuplicates")
    @JsonIgnore
    public CollectionPage<EntityValidationDuplicate> getValidationDuplicates() {
        return new CollectionPage<EntityValidationDuplicate>(contextPath, EntityValidationDuplicate.class, validationDuplicates, Optional.ofNullable(validationDuplicatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @Property(name="Messages")
    @JsonIgnore
    public CollectionPage<EntityValidationMessage> getMessages() {
        return new CollectionPage<EntityValidationMessage>(contextPath, EntityValidationMessage.class, messages, Optional.ofNullable(messagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList());
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer validEntityCount;
        private List<EntityValidationDuplicate> validationDuplicates;
        private String validationDuplicatesNextLink;
        private List<EntityValidationMessage> messages;
        private String messagesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validEntityCount(Integer validEntityCount) {
            this.validEntityCount = validEntityCount;
            this.changedFields = changedFields.add("ValidEntityCount");
            return this;
        }

        public Builder validationDuplicates(List<EntityValidationDuplicate> validationDuplicates) {
            this.validationDuplicates = validationDuplicates;
            this.changedFields = changedFields.add("ValidationDuplicates");
            return this;
        }

        public Builder validationDuplicatesNextLink(String validationDuplicatesNextLink) {
            this.validationDuplicatesNextLink = validationDuplicatesNextLink;
            this.changedFields = changedFields.add("ValidationDuplicates");
            return this;
        }

        public Builder messages(List<EntityValidationMessage> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public Builder messagesNextLink(String messagesNextLink) {
            this.messagesNextLink = messagesNextLink;
            this.changedFields = changedFields.add("Messages");
            return this;
        }

        public EntitiesValidationResult build() {
            EntitiesValidationResult _x = new EntitiesValidationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntitiesValidationResult";
            _x.validEntityCount = validEntityCount;
            _x.validationDuplicates = validationDuplicates;
            _x.validationDuplicatesNextLink = validationDuplicatesNextLink;
            _x.messages = messages;
            _x.messagesNextLink = messagesNextLink;
            return _x;
        }
    }

    private EntitiesValidationResult _copy() {
        EntitiesValidationResult _x = new EntitiesValidationResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.validEntityCount = validEntityCount;
        _x.validationDuplicates = validationDuplicates;
        _x.messages = messages;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntitiesValidationResult[");
        b.append("ValidEntityCount=");
        b.append(this.validEntityCount);
        b.append(", ");
        b.append("ValidationDuplicates=");
        b.append(this.validationDuplicates);
        b.append(", ");
        b.append("Messages=");
        b.append(this.messages);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
