package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.complex.ValidatedEntity;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Duplicate", 
    "DuplicateOf"})
public class EntityAppendDuplicate implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Duplicate")
    protected ValidatedEntity duplicate;

    @JsonProperty("DuplicateOf")
    protected ValidatedEntity duplicateOf;

    protected EntityAppendDuplicate() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityAppendDuplicate";
    }

    @Property(name="Duplicate")
    @JsonIgnore
    public Optional<ValidatedEntity> getDuplicate() {
        return Optional.ofNullable(duplicate);
    }

    public EntityAppendDuplicate withDuplicate(ValidatedEntity duplicate) {
        EntityAppendDuplicate _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityAppendDuplicate");
        _x.duplicate = duplicate;
        return _x;
    }

    @Property(name="DuplicateOf")
    @JsonIgnore
    public Optional<ValidatedEntity> getDuplicateOf() {
        return Optional.ofNullable(duplicateOf);
    }

    public EntityAppendDuplicate withDuplicateOf(ValidatedEntity duplicateOf) {
        EntityAppendDuplicate _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityAppendDuplicate");
        _x.duplicateOf = duplicateOf;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ValidatedEntity duplicate;
        private ValidatedEntity duplicateOf;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder duplicate(ValidatedEntity duplicate) {
            this.duplicate = duplicate;
            this.changedFields = changedFields.add("Duplicate");
            return this;
        }

        public Builder duplicateOf(ValidatedEntity duplicateOf) {
            this.duplicateOf = duplicateOf;
            this.changedFields = changedFields.add("DuplicateOf");
            return this;
        }

        public EntityAppendDuplicate build() {
            EntityAppendDuplicate _x = new EntityAppendDuplicate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityAppendDuplicate";
            _x.duplicate = duplicate;
            _x.duplicateOf = duplicateOf;
            return _x;
        }
    }

    private EntityAppendDuplicate _copy() {
        EntityAppendDuplicate _x = new EntityAppendDuplicate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.duplicate = duplicate;
        _x.duplicateOf = duplicateOf;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityAppendDuplicate[");
        b.append("Duplicate=");
        b.append(this.duplicate);
        b.append(", ");
        b.append("DuplicateOf=");
        b.append(this.duplicateOf);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
