package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.extractions.subjectlists.complex.EntitiesAppendIdentifiersResult;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "ImportFileName", 
    "CorrelationId", 
    "ImportStart", 
    "ImportEnd", 
    "ImportDuration", 
    "AppendResult"})
public class EntityListImportResult implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ImportFileName")
    protected String importFileName;

    @JsonProperty("CorrelationId")
    protected String correlationId;

    @JsonProperty("ImportStart")
    protected OffsetDateTime importStart;

    @JsonProperty("ImportEnd")
    protected OffsetDateTime importEnd;

    @JsonProperty("ImportDuration")
    protected Duration importDuration;

    @JsonProperty("AppendResult")
    protected EntitiesAppendIdentifiersResult appendResult;

    protected EntityListImportResult() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult";
    }

    @Property(name="ImportFileName")
    @JsonIgnore
    public Optional<String> getImportFileName() {
        return Optional.ofNullable(importFileName);
    }

    public EntityListImportResult withImportFileName(String importFileName) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.importFileName = importFileName;
        return _x;
    }

    @Property(name="CorrelationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    public EntityListImportResult withCorrelationId(String correlationId) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.correlationId = correlationId;
        return _x;
    }

    @Property(name="ImportStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getImportStart() {
        return Optional.ofNullable(importStart);
    }

    public EntityListImportResult withImportStart(OffsetDateTime importStart) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.importStart = importStart;
        return _x;
    }

    @Property(name="ImportEnd")
    @JsonIgnore
    public Optional<OffsetDateTime> getImportEnd() {
        return Optional.ofNullable(importEnd);
    }

    public EntityListImportResult withImportEnd(OffsetDateTime importEnd) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.importEnd = importEnd;
        return _x;
    }

    @Property(name="ImportDuration")
    @JsonIgnore
    public Optional<Duration> getImportDuration() {
        return Optional.ofNullable(importDuration);
    }

    public EntityListImportResult withImportDuration(Duration importDuration) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.importDuration = importDuration;
        return _x;
    }

    @Property(name="AppendResult")
    @JsonIgnore
    public Optional<EntitiesAppendIdentifiersResult> getAppendResult() {
        return Optional.ofNullable(appendResult);
    }

    public EntityListImportResult withAppendResult(EntitiesAppendIdentifiersResult appendResult) {
        EntityListImportResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult");
        _x.appendResult = appendResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String importFileName;
        private String correlationId;
        private OffsetDateTime importStart;
        private OffsetDateTime importEnd;
        private Duration importDuration;
        private EntitiesAppendIdentifiersResult appendResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder importFileName(String importFileName) {
            this.importFileName = importFileName;
            this.changedFields = changedFields.add("ImportFileName");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("CorrelationId");
            return this;
        }

        public Builder importStart(OffsetDateTime importStart) {
            this.importStart = importStart;
            this.changedFields = changedFields.add("ImportStart");
            return this;
        }

        public Builder importEnd(OffsetDateTime importEnd) {
            this.importEnd = importEnd;
            this.changedFields = changedFields.add("ImportEnd");
            return this;
        }

        public Builder importDuration(Duration importDuration) {
            this.importDuration = importDuration;
            this.changedFields = changedFields.add("ImportDuration");
            return this;
        }

        public Builder appendResult(EntitiesAppendIdentifiersResult appendResult) {
            this.appendResult = appendResult;
            this.changedFields = changedFields.add("AppendResult");
            return this;
        }

        public EntityListImportResult build() {
            EntityListImportResult _x = new EntityListImportResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportResult";
            _x.importFileName = importFileName;
            _x.correlationId = correlationId;
            _x.importStart = importStart;
            _x.importEnd = importEnd;
            _x.importDuration = importDuration;
            _x.appendResult = appendResult;
            return _x;
        }
    }

    private EntityListImportResult _copy() {
        EntityListImportResult _x = new EntityListImportResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.importFileName = importFileName;
        _x.correlationId = correlationId;
        _x.importStart = importStart;
        _x.importEnd = importEnd;
        _x.importDuration = importDuration;
        _x.appendResult = appendResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityListImportResult[");
        b.append("ImportFileName=");
        b.append(this.importFileName);
        b.append(", ");
        b.append("CorrelationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("ImportStart=");
        b.append(this.importStart);
        b.append(", ");
        b.append("ImportEnd=");
        b.append(this.importEnd);
        b.append(", ");
        b.append("ImportDuration=");
        b.append(this.importDuration);
        b.append(", ");
        b.append("AppendResult=");
        b.append(this.appendResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
