package thomsonreuters.dss.api.extractions.subjectlists.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.extractions.enums.ImportActionEnum;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "PredefinedName", 
    "PredefinedAction", 
    "ImportUserEntities", 
    "AllowDuplicateEntities"})
public class EntityListImportSettings implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PredefinedName")
    protected String predefinedName;

    @JsonProperty("PredefinedAction")
    protected ImportActionEnum predefinedAction;

    @JsonProperty("ImportUserEntities")
    protected Boolean importUserEntities;

    @JsonProperty("AllowDuplicateEntities")
    protected Boolean allowDuplicateEntities;

    protected EntityListImportSettings() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings";
    }

    @Property(name="PredefinedName")
    @JsonIgnore
    public Optional<String> getPredefinedName() {
        return Optional.ofNullable(predefinedName);
    }

    public EntityListImportSettings withPredefinedName(String predefinedName) {
        EntityListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings");
        _x.predefinedName = predefinedName;
        return _x;
    }

    @Property(name="PredefinedAction")
    @JsonIgnore
    public Optional<ImportActionEnum> getPredefinedAction() {
        return Optional.ofNullable(predefinedAction);
    }

    public EntityListImportSettings withPredefinedAction(ImportActionEnum predefinedAction) {
        EntityListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings");
        _x.predefinedAction = predefinedAction;
        return _x;
    }

    @Property(name="ImportUserEntities")
    @JsonIgnore
    public Optional<Boolean> getImportUserEntities() {
        return Optional.ofNullable(importUserEntities);
    }

    public EntityListImportSettings withImportUserEntities(Boolean importUserEntities) {
        EntityListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings");
        _x.importUserEntities = importUserEntities;
        return _x;
    }

    @Property(name="AllowDuplicateEntities")
    @JsonIgnore
    public Optional<Boolean> getAllowDuplicateEntities() {
        return Optional.ofNullable(allowDuplicateEntities);
    }

    public EntityListImportSettings withAllowDuplicateEntities(Boolean allowDuplicateEntities) {
        EntityListImportSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings");
        _x.allowDuplicateEntities = allowDuplicateEntities;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String predefinedName;
        private ImportActionEnum predefinedAction;
        private Boolean importUserEntities;
        private Boolean allowDuplicateEntities;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder predefinedName(String predefinedName) {
            this.predefinedName = predefinedName;
            this.changedFields = changedFields.add("PredefinedName");
            return this;
        }

        public Builder predefinedAction(ImportActionEnum predefinedAction) {
            this.predefinedAction = predefinedAction;
            this.changedFields = changedFields.add("PredefinedAction");
            return this;
        }

        public Builder importUserEntities(Boolean importUserEntities) {
            this.importUserEntities = importUserEntities;
            this.changedFields = changedFields.add("ImportUserEntities");
            return this;
        }

        public Builder allowDuplicateEntities(Boolean allowDuplicateEntities) {
            this.allowDuplicateEntities = allowDuplicateEntities;
            this.changedFields = changedFields.add("AllowDuplicateEntities");
            return this;
        }

        public EntityListImportSettings build() {
            EntityListImportSettings _x = new EntityListImportSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Extractions.SubjectLists.EntityListImportSettings";
            _x.predefinedName = predefinedName;
            _x.predefinedAction = predefinedAction;
            _x.importUserEntities = importUserEntities;
            _x.allowDuplicateEntities = allowDuplicateEntities;
            return _x;
        }
    }

    private EntityListImportSettings _copy() {
        EntityListImportSettings _x = new EntityListImportSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.predefinedName = predefinedName;
        _x.predefinedAction = predefinedAction;
        _x.importUserEntities = importUserEntities;
        _x.allowDuplicateEntities = allowDuplicateEntities;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityListImportSettings[");
        b.append("PredefinedName=");
        b.append(this.predefinedName);
        b.append(", ");
        b.append("PredefinedAction=");
        b.append(this.predefinedAction);
        b.append(", ");
        b.append("ImportUserEntities=");
        b.append(this.importUserEntities);
        b.append(", ");
        b.append("AllowDuplicateEntities=");
        b.append(this.allowDuplicateEntities);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
